/*
 * Decompiled with CFR 0.152.
 */
package com.fire.yf.controller.basic;

import com.alibaba.fastjson.JSON;
import com.fire.base.common.AjaxResult;
import com.fire.base.common.Result;
import com.fire.base.entity.BaseCheckReq;
import com.fire.base.entity.BaseQueryReq;
import com.fire.base.entity.BaseReq;
import com.fire.base.utils.StringUtils;
import com.fire.yf.controller.basic.bc.BaseController;
import com.fire.yf.entity.PurOrder;
import com.fire.yf.entity.ReturnGoods;
import com.fire.yf.entity.TestReturnGoods;
import com.fire.yf.entity.check.PurOrderCheck;
import com.fire.yf.entity.check.ReturnGoodsCheck;
import com.fire.yf.service.IOutboundService;
import com.fire.yf.service.IPurModuleService;
import com.fire.yf.service.IWarehousingService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSort;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="===\u91c7\u8d2d\u6a21\u5757===", tags={"===\u91c7\u8d2d\u6a21\u5757==="})
@ApiSort(value=20)
@RequestMapping(value={"/"})
public class PurModuleController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(PurModuleController.class);
    @Autowired
    private IWarehousingService warehousingService;
    @Autowired
    private IOutboundService outboundService;
    @Autowired
    private IPurModuleService purModuleService;

    @PostMapping(value={"/warehousing/createPurOrder"})
    @ApiOperation(value="\u521b\u5efa\u91c7\u8d2d\u8fdb\u8d27\u5355", notes="\u521b\u5efa\u91c7\u8d2d\u8fdb\u8d27\u5355", tags={"\u91c7\u8d2d\u8fdb\u8d27\u5355"})
    @ApiOperationSupport(order=1)
    public AjaxResult createPurOrder(@Validated @RequestBody PurOrder purOrder) {
        log.info(JSON.toJSONString((Object)purOrder));
        this.commonCheckPost((BaseReq)purOrder);
        return this.warehousingService.createPurOrder(purOrder);
    }

    @PostMapping(value={"/warehousing/createAndApprovePurOrder"})
    @ApiOperation(value="\u521b\u5efa\u5e76\u5ba1\u6838\u91c7\u8d2d\u8fdb\u8d27\u5355", notes="\u521b\u5efa\u5e76\u5ba1\u6838\u91c7\u8d2d\u8fdb\u8d27\u5355", tags={"\u91c7\u8d2d\u8fdb\u8d27\u5355"})
    @ApiOperationSupport(order=3)
    public AjaxResult createAndApprovePurOrder(@Validated @RequestBody PurOrder purOrder) {
        log.info(JSON.toJSONString((Object)purOrder));
        this.commonCheckPost((BaseReq)purOrder);
        return this.warehousingService.createAndApprovePurOrder(purOrder);
    }

    @PostMapping(value={"/warehousing/updatePurOrder"})
    @ApiOperation(value="\u4fee\u6539\u8fdb\u8d27\u5355", notes="\u4fee\u6539\u8fdb\u8d27\u5355", tags={"\u91c7\u8d2d\u8fdb\u8d27\u5355"})
    @ApiOperationSupport(order=4)
    public AjaxResult updatePurOrder(@Validated @RequestBody PurOrder purOrder) {
        log.info(JSON.toJSONString((Object)purOrder));
        this.commonCheckPost((BaseReq)purOrder);
        return this.purModuleService.updatePurOrder(purOrder);
    }

    @PostMapping(value={"/warehousing/updateAndApprovePurOrder"})
    @ApiOperation(value="\u4fee\u6539\u5e76\u5ba1\u6838\u8fdb\u8d27\u5355", notes="\u4fee\u6539\u5e76\u5ba1\u6838\u8fdb\u8d27\u5355", tags={"\u91c7\u8d2d\u8fdb\u8d27\u5355"})
    @ApiOperationSupport(order=5)
    public AjaxResult updateAndApprovePurOrder(@Validated @RequestBody PurOrder purOrder) {
        log.info(JSON.toJSONString((Object)purOrder));
        this.commonCheckPost((BaseReq)purOrder);
        return this.purModuleService.updateAndApprovePurOrder(purOrder);
    }

    @PostMapping(value={"/warehousing/approvePurOrder"})
    @ApiOperation(value="\u5ba1\u6838\u91c7\u8d2d\u8fdb\u8d27\u5355", notes="\u5ba1\u6838\u91c7\u8d2d\u8fdb\u8d27\u5355", tags={"\u91c7\u8d2d\u8fdb\u8d27\u5355"})
    @ApiOperationSupport(order=9)
    public AjaxResult approvePurOrder(@RequestBody PurOrderCheck purOrderCheck) {
        log.info(JSON.toJSONString((Object)purOrderCheck));
        this.commonCheckPost((BaseCheckReq)purOrderCheck);
        return this.warehousingService.approvePurOrder(purOrderCheck);
    }

    @PostMapping(value={"/warehousing/createPurOrderAuto"})
    @ApiOperation(value="\u521b\u5efa\u91c7\u8d2d\u8fdb\u8d27\u5355(\u81ea\u52a8\u5206\u914d)", notes="\u521b\u5efa\u91c7\u8d2d\u8fdb\u8d27\u5355", tags={"\u91c7\u8d2d\u8fdb\u8d27\u5355"})
    @ApiOperationSupport(order=10)
    public AjaxResult createPurOrderAuto(@Validated @RequestBody PurOrder purOrder) {
        log.info(JSON.toJSONString((Object)purOrder));
        this.commonCheckPost((BaseReq)purOrder);
        return this.purModuleService.createPurOrderAuto(purOrder);
    }

    @PostMapping(value={"/warehousing/createAndApprovePurOrderAuto"})
    @ApiOperation(value="\u521b\u5efa\u5e76\u5ba1\u6838\u91c7\u8d2d\u8fdb\u8d27\u5355(\u81ea\u52a8\u5206\u914d)", notes="\u521b\u5efa\u91c7\u8d2d\u8fdb\u8d27\u5355", tags={"\u91c7\u8d2d\u8fdb\u8d27\u5355"})
    @ApiOperationSupport(order=10)
    public AjaxResult createAndApprovePurOrderAuto(@Validated @RequestBody PurOrder purOrder) {
        log.info(JSON.toJSONString((Object)purOrder));
        this.commonCheckPost((BaseReq)purOrder);
        return this.purModuleService.createAndApprovePurOrderAuto(purOrder);
    }

    @PostMapping(value={"/warehousing/acceptancePurOrderAuto"})
    @ApiOperation(value="\u4fee\u6539\u91c7\u8d2d\u8fdb\u8d27\u5355(\u5355\u884c\u9a8c\u6536)", notes="\u4fee\u6539\u91c7\u8d2d\u8fdb\u8d27\u5355(\u5355\u884c\u9a8c\u6536)", tags={"\u91c7\u8d2d\u8fdb\u8d27\u5355"})
    @ApiOperationSupport(order=10)
    public AjaxResult acceptancePurOrderAuto(@RequestBody PurOrder purOrder) {
        log.info(JSON.toJSONString((Object)purOrder));
        this.commonCheckPost((BaseReq)purOrder);
        return this.purModuleService.acceptancePurOrderAuto(purOrder);
    }

    @PostMapping(value={"/warehousing/unAcceptancePurOrderAuto"})
    @ApiOperation(value="\u4fee\u6539\u91c7\u8d2d\u8fdb\u8d27\u5355(\u5355\u884c\u53cd\u9a8c\u6536)", notes="\u4fee\u6539\u91c7\u8d2d\u8fdb\u8d27\u5355(\u5355\u884c\u53cd\u9a8c\u6536)", tags={"\u91c7\u8d2d\u8fdb\u8d27\u5355"})
    @ApiOperationSupport(order=10)
    public AjaxResult unAcceptancePurOrderAuto(@RequestBody PurOrder purOrder) {
        log.info(JSON.toJSONString((Object)purOrder));
        this.commonCheckPost((BaseReq)purOrder);
        return this.purModuleService.unAcceptancePurOrderAuto(purOrder);
    }

    @PostMapping(value={"/warehousing/acceptanceAndApprovePurOrderAuto"})
    @ApiOperation(value="\u4fee\u6539\u5e76\u5ba1\u6838\u91c7\u8d2d\u8fdb\u8d27\u5355(\u5355\u884c\u9a8c\u6536\u5e76\u5ba1\u6838)", notes="\u4fee\u6539\u5e76\u5ba1\u6838\u91c7\u8d2d\u8fdb\u8d27\u5355(\u5355\u884c\u9a8c\u6536\u5e76\u5ba1\u6838)", tags={"\u91c7\u8d2d\u8fdb\u8d27\u5355"})
    @ApiOperationSupport(order=10)
    public AjaxResult acceptanceAndApprovePurOrderAuto(@RequestBody PurOrder purOrder) {
        log.info(JSON.toJSONString((Object)purOrder));
        this.commonCheckPost((BaseReq)purOrder);
        return this.purModuleService.acceptanceAndApprovePurOrderAuto(purOrder);
    }

    @GetMapping(value={"/outbound/queryReturnGoods"})
    @ApiOperation(value="\u67e5\u8be2\u91c7\u8d2d\u9000\u8d27", notes="\u67e5\u8be2\u91c7\u8d2d\u9000\u8d27", tags={"\u91c7\u8d2d\u9000\u8d27\u5355"})
    @ApiOperationSupport(order=11)
    public Result<List<ReturnGoods>> queryReturnGoods(BaseQueryReq baseQueryReq) {
        log.info(JSON.toJSONString((Object)baseQueryReq));
        this.commonCheckGet(baseQueryReq);
        return this.outboundService.queryReturnGoods(baseQueryReq);
    }

    @PostMapping(value={"/outbound/createReturnGoods"})
    @ApiOperation(value="\u521b\u5efa\u91c7\u8d2d\u9000\u8d27", notes="\u521b\u5efa\u91c7\u8d2d\u9000\u8d27", tags={"\u91c7\u8d2d\u9000\u8d27\u5355"})
    @ApiOperationSupport(order=13)
    public AjaxResult createReturnGoods(@RequestBody ReturnGoods returnGoods) {
        log.info(JSON.toJSONString((Object)returnGoods));
        this.commonCheckPost((BaseReq)returnGoods);
        return this.outboundService.createReturnGoods(returnGoods);
    }

    @PostMapping(value={"/outbound/createAndApproveReturnGoods"})
    @ApiOperation(value="\u521b\u5efa\u5e76\u5ba1\u6838\u91c7\u8d2d\u9000\u8d27", notes="\u521b\u5efa\u5e76\u5ba1\u6838\u91c7\u8d2d\u9000\u8d27", tags={"\u91c7\u8d2d\u9000\u8d27\u5355"})
    @ApiOperationSupport(order=15)
    public AjaxResult createAndApproveReturnGoods(@RequestBody ReturnGoods returnGoods) {
        log.info(JSON.toJSONString((Object)returnGoods));
        this.commonCheckPost((BaseReq)returnGoods);
        return this.outboundService.createAndApproveReturnGoods(returnGoods);
    }

    @PostMapping(value={"/outbound/updReturnGoods"})
    @ApiOperation(value="\u4fee\u6539\u91c7\u8d2d\u9000\u8d27", notes="\u4fee\u6539\u91c7\u8d2d\u9000\u8d27", tags={"\u91c7\u8d2d\u9000\u8d27\u5355"})
    @ApiOperationSupport(order=16)
    public AjaxResult updReturnGoods(@RequestBody ReturnGoods returnGoods) {
        log.info(JSON.toJSONString((Object)returnGoods));
        this.commonCheckPost((BaseReq)returnGoods);
        return this.outboundService.updReturnGoods(returnGoods);
    }

    @PostMapping(value={"/outbound/updAndApproveReturnGoods"})
    @ApiOperation(value="\u4fee\u6539\u5e76\u5ba1\u6838\u91c7\u8d2d\u9000\u8d27", notes="\u4fee\u6539\u5e76\u5ba1\u6838\u91c7\u8d2d\u9000\u8d27", tags={"\u91c7\u8d2d\u9000\u8d27\u5355"})
    @ApiOperationSupport(order=17)
    public AjaxResult updAndApproveReturnGoods(@RequestBody ReturnGoods returnGoods) {
        log.info(JSON.toJSONString((Object)returnGoods));
        this.commonCheckPost((BaseReq)returnGoods);
        return this.outboundService.updAndApproveReturnGoods(returnGoods);
    }

    @PostMapping(value={"/outbound/splitRowsReturnGoods"})
    @ApiOperation(value="\u91c7\u8d2d\u9000\u8d27\u5355(\u62c6\u884c)", notes="\u91c7\u8d2d\u9000\u8d27\u5355(\u62c6\u884c)", tags={"\u91c7\u8d2d\u9000\u8d27\u5355"})
    @ApiOperationSupport(order=18)
    public AjaxResult splitRowsReturnGoods(@RequestBody ReturnGoods returnGoods) {
        log.info(JSON.toJSONString((Object)returnGoods));
        this.commonCheckPost((BaseReq)returnGoods);
        return this.outboundService.splitRowsReturnGoods(returnGoods);
    }

    @PostMapping(value={"/outbound/approveReturnGoods"})
    @ApiOperation(value="\u5ba1\u6838\u91c7\u8d2d\u9000\u8d27", notes="\u5ba1\u6838\u91c7\u8d2d\u9000\u8d27", tags={"\u91c7\u8d2d\u9000\u8d27\u5355"})
    @ApiOperationSupport(order=19)
    public AjaxResult approveReturnGoods(@RequestBody ReturnGoodsCheck returnGoodsCheck) {
        log.info(JSON.toJSONString((Object)returnGoodsCheck));
        this.commonCheckPost((BaseCheckReq)returnGoodsCheck);
        return this.outboundService.approveReturnGoods(returnGoodsCheck);
    }

    @PostMapping(value={"/outbound/createTestReturnGoods"})
    @ApiOperation(value="\u521b\u5efa\u9a8c\u9000\u5355", notes="\u521b\u5efa\u9a8c\u9000\u5355", tags={"\u9a8c\u9000\u5355"})
    @ApiOperationSupport(order=21)
    public AjaxResult createTestReturnGoods(@RequestBody TestReturnGoods testReturnGoods) {
        log.info(JSON.toJSONString((Object)testReturnGoods));
        if (StringUtils.isEmpty((String)testReturnGoods.getCompanyId())) {
            return AjaxResult.fail((String)"\u8bf7\u8f93\u5165companyId");
        }
        return this.outboundService.createTestReturnGoods(testReturnGoods);
    }
}

