/*
 * Decompiled with CFR 0.152.
 */
package com.fire.yf.controller.basic;

import com.alibaba.fastjson.JSON;
import com.fire.base.common.AjaxResult;
import com.fire.base.common.Result;
import com.fire.base.entity.BaseCheckReq;
import com.fire.base.entity.BaseQueryReq;
import com.fire.base.entity.BaseReq;
import com.fire.base.utils.StringUtils;
import com.fire.yf.controller.basic.bc.BaseController;
import com.fire.yf.entity.BaseQuery;
import com.fire.yf.entity.SaleGoods;
import com.fire.yf.entity.SaleReturnGoods;
import com.fire.yf.entity.ShippingNoticeBody;
import com.fire.yf.entity.check.SaleGoodsCheck;
import com.fire.yf.entity.check.SaleReturnGoodsCheck;
import com.fire.yf.entity.update.SaleReturnGoodsUpd;
import com.fire.yf.service.IOutboundService;
import com.fire.yf.service.IWarehousingService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSort;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="===\u9500\u552e\u6a21\u5757===", tags={"===\u9500\u552e\u6a21\u5757==="})
@ApiSort(value=10)
@RequestMapping(value={"/"})
public class SalesModuleController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(SalesModuleController.class);
    @Autowired
    private IWarehousingService warehousingService;
    @Autowired
    private IOutboundService outboundService;

    @GetMapping(value={"/outbound/queryShippingNotice"})
    @ApiOperation(value="\u67e5\u8be2\u51fa\u8d27\u901a\u77e5\u5355", notes="\u67e5\u8be2\u51fa\u8d27\u901a\u77e5\u5355", tags={"\u51fa\u8d27\u901a\u77e5\u5355"})
    @ApiOperationSupport(order=1)
    public Result<List<ShippingNoticeBody>> queryShippingNotice(ShippingNoticeBody shippingNoticeBody) {
        log.info(JSON.toJSONString((Object)shippingNoticeBody));
        this.commonCheckCompanyId((BaseQueryReq)shippingNoticeBody);
        return this.outboundService.queryShippingNotice(shippingNoticeBody);
    }

    @GetMapping(value={"/outbound/querySaleGoods"})
    @ApiOperation(value="\u67e5\u8be2\u9500\u8d27\u5355", notes="\u67e5\u8be2\u9500\u8d27\u5355", tags={"\u9500\u8d27\u5355"})
    @ApiOperationSupport(order=1)
    public Result<List<SaleGoods>> querySaleGoods(BaseQuery baseQuery) {
        log.info(JSON.toJSONString((Object)baseQuery));
        this.commonCheckGet((BaseQueryReq)baseQuery);
        return this.outboundService.querySaleGoods(baseQuery);
    }

    @PostMapping(value={"/outbound/createSaleGoods"})
    @ApiOperation(value="\u521b\u5efa\u9500\u8d27\u5355", notes="\u521b\u5efa\u9500\u8d27\u5355", tags={"\u9500\u8d27\u5355"})
    @ApiOperationSupport(order=3)
    public AjaxResult createSaleGoods(@RequestBody SaleGoods saleGoods) {
        log.info(JSON.toJSONString((Object)saleGoods));
        this.commonCheckPost((BaseReq)saleGoods);
        return this.outboundService.createSaleGoods(saleGoods);
    }

    @PostMapping(value={"/outbound/createAndApproveSaleGoods"})
    @ApiOperation(value="\u521b\u5efa\u5e76\u5ba1\u6838\u9500\u8d27\u5355", notes="\u521b\u5efa\u5e76\u5ba1\u6838\u9500\u8d27\u5355", tags={"\u9500\u8d27\u5355"})
    @ApiOperationSupport(order=5)
    public AjaxResult createAndApproveSaleGoods(@RequestBody SaleGoods saleGoods) {
        log.info(JSON.toJSONString((Object)saleGoods));
        this.commonCheckPost((BaseReq)saleGoods);
        return this.outboundService.createAndApproveSaleGoods(saleGoods);
    }

    @PostMapping(value={"/outbound/updAndApproveSaleGoods"})
    @ApiOperation(value="\u4fee\u6539\u5e76\u5ba1\u6838\u9500\u8d27\u5355", notes="\u4fee\u6539\u5e76\u5ba1\u6838\u9500\u8d27\u5355", tags={"\u9500\u8d27\u5355"})
    @ApiOperationSupport(order=7)
    public AjaxResult updAndApproveSaleGoods(@RequestBody SaleGoods saleGoods) {
        log.info(JSON.toJSONString((Object)saleGoods));
        this.commonCheckPost((BaseReq)saleGoods);
        return this.outboundService.updAndApproveSaleGoods(saleGoods);
    }

    @PostMapping(value={"/outbound/approveSaleGoods"})
    @ApiOperation(value="\u5ba1\u6838\u9500\u8d27\u5355", notes="\u5ba1\u6838\u9500\u8d27\u5355", tags={"\u9500\u8d27\u5355"})
    @ApiOperationSupport(order=9)
    public AjaxResult approveSaleGoods(@RequestBody SaleGoodsCheck saleGoodsCheck) {
        log.info(JSON.toJSONString((Object)saleGoodsCheck));
        this.commonCheckPost((BaseCheckReq)saleGoodsCheck);
        return this.outboundService.approveSaleGoods(saleGoodsCheck);
    }

    @PostMapping(value={"/outbound/splitRowsSaleGoods"})
    @ApiOperation(value="\u9500\u8d27\u5355(\u62c6\u884c)", notes="\u9500\u8d27\u5355(\u62c6\u884c)", tags={"\u9500\u8d27\u5355"})
    @ApiOperationSupport(order=17)
    public AjaxResult splitRowsSaleGoods(@RequestBody SaleGoods saleGoods) {
        log.info(JSON.toJSONString((Object)saleGoods));
        this.commonCheckPost((BaseReq)saleGoods);
        return this.outboundService.splitRowsSaleGoods(saleGoods);
    }

    @GetMapping(value={"/warehousing/querySaleReturnGoods"})
    @ApiOperation(value="\u9500\u9000\u5355\u67e5\u8be2", notes="\u9500\u9000\u5355\u67e5\u8be2", tags={"\u9500\u9000\u5355"})
    @ApiOperationSupport(order=11)
    public Result<List<SaleReturnGoods>> querySaleReturnGoods(BaseQuery baseQuery) {
        log.info(JSON.toJSONString((Object)baseQuery));
        this.commonCheckGet((BaseQueryReq)baseQuery);
        return this.warehousingService.querySaleReturnGoods(baseQuery);
    }

    @PostMapping(value={"/warehousing/updAndApproveSaleReturnGoods"})
    @ApiOperation(value="\u4fee\u6539\u5e76\u5ba1\u6838\u9500\u9000\u5355", notes="\u4fee\u6539\u5e76\u5ba1\u6838\u9500\u9000\u5355", tags={"\u9500\u9000\u5355"})
    @ApiOperationSupport(order=13)
    public AjaxResult updAndApproveSaleReturnGoods(@RequestBody SaleReturnGoodsUpd saleReturnGoods) {
        log.info(JSON.toJSONString((Object)saleReturnGoods));
        if (StringUtils.isEmpty((String)saleReturnGoods.getCompanyId())) {
            return AjaxResult.fail((String)"\u8bf7\u8f93\u5165companyId");
        }
        saleReturnGoods.setModifyType("1");
        return this.warehousingService.updAndApproveSaleReturnGoods(saleReturnGoods);
    }

    @PostMapping(value={"/warehousing/approveSaleReturnGoods"})
    @ApiOperation(value="\u5ba1\u6838\u9500\u9000\u5355", notes="\u5ba1\u6838\u9500\u9000\u5355", tags={"\u9500\u9000\u5355"})
    @ApiOperationSupport(order=15)
    public AjaxResult approveSaleReturnGoods(@RequestBody SaleReturnGoodsCheck saleReturnGoodsCheck) {
        log.info(JSON.toJSONString((Object)saleReturnGoodsCheck));
        if (StringUtils.isEmpty((String)saleReturnGoodsCheck.getCompanyId())) {
            return AjaxResult.fail((String)"\u8bf7\u8f93\u5165companyId");
        }
        return this.warehousingService.approveSaleReturnGoods(saleReturnGoodsCheck);
    }
}

