/*
 * Decompiled with CFR 0.152.
 */
package com.fire.yf.controller.basic.old;

import com.alibaba.fastjson.JSON;
import com.fire.base.common.AjaxResult;
import com.fire.base.common.Result;
import com.fire.base.exception.BaseException;
import com.fire.base.utils.FileUtils;
import com.fire.base.utils.StringUtils;
import com.fire.yf.entity.AnalysisWorkOrders;
import com.fire.yf.entity.GoodsEnclosure;
import com.fire.yf.entity.InventoryItem;
import com.fire.yf.entity.ShortageMaterials;
import com.fire.yf.entity.VarianceAdjustment;
import com.fire.yf.service.IAdjustmentService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSort;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ApiSort(value=3)
@Api(value="\u8c03\u6574\u4e1a\u52a1\u96c6\u5408", tags={"==\u8c03\u6574\u4e1a\u52a1\u96c6\u5408=="})
@RequestMapping(value={"/adjustment"})
public class AdjustmentController {
    private static final Logger log = LoggerFactory.getLogger(AdjustmentController.class);
    @Autowired
    private IAdjustmentService adjustmentService;

    @PostMapping(value={"/generateVarianceAdjustment"})
    @ApiOperation(value="\u76d8\u76c8\u76d8\u4e8f\u56de\u5199\u63a5\u53e3", notes="\u76d8\u76c8\u76d8\u4e8f\u56de\u5199\u63a5\u53e3")
    @ApiOperationSupport(order=1)
    public AjaxResult generateVarianceAdjustment(@RequestBody VarianceAdjustment varianceAdjustment) {
        log.info(JSON.toJSONString((Object)varianceAdjustment));
        if (StringUtils.isEmpty((String)varianceAdjustment.getCompanyId())) {
            return AjaxResult.fail((String)"\u8bf7\u8f93\u5165companyId");
        }
        return this.adjustmentService.generateVarianceAdjustment(varianceAdjustment);
    }

    @PostMapping(value={"/inventoryItemSubmission"})
    @ApiOperation(value="\u76d8\u70b9\u6599\u4ef6\u63d0\u4ea4\u63a5\u53e3", notes="\u76d8\u70b9\u6599\u4ef6\u63d0\u4ea4\u63a5\u53e3")
    @ApiOperationSupport(order=2)
    public AjaxResult inventoryItemSubmission(@RequestBody InventoryItem inventoryItem) {
        log.info(JSON.toJSONString((Object)inventoryItem));
        if (StringUtils.isEmpty((String)inventoryItem.getCompanyId())) {
            return AjaxResult.fail((String)"\u8bf7\u8f93\u5165companyId");
        }
        return this.adjustmentService.inventoryItemSubmission(inventoryItem);
    }

    @GetMapping(value={"/queryShortageMaterials"})
    @ApiOperation(value="ERP\u6b20\u6599\u8868\u67e5\u8be2\u63a5\u53e3", notes="ERP\u6b20\u6599\u8868\u67e5\u8be2\u63a5\u53e3")
    @ApiOperationSupport(order=10)
    public Result<List<ShortageMaterials>> queryShortageMaterials(ShortageMaterials shortageMaterials) {
        log.info(JSON.toJSONString((Object)shortageMaterials));
        if (StringUtils.isEmpty((String)shortageMaterials.getCompanyId())) {
            return new Result(500, "\u8bf7\u8f93\u5165companyId", null);
        }
        return this.adjustmentService.queryShortageMaterials(shortageMaterials);
    }

    @GetMapping(value={"/queryGoodsEnclosure"})
    @ApiOperation(value="\u54c1\u53f7\u9644\u4ef6\u67e5\u8be2\u63a5\u53e3", notes="\u54c1\u53f7\u9644\u4ef6\u67e5\u8be2\u63a5\u53e3")
    @ApiOperationSupport(order=15)
    public Result<List<GoodsEnclosure>> queryGoodsEnclosure(GoodsEnclosure goodsEnclosure) {
        log.info(JSON.toJSONString((Object)goodsEnclosure));
        if (StringUtils.isEmpty((String)goodsEnclosure.getCompanyId())) {
            return new Result(500, "\u8bf7\u8f93\u5165companyId", null);
        }
        return this.adjustmentService.queryGoodsEnclosure(goodsEnclosure);
    }

    @GetMapping(value={"/download"})
    @ApiOperation(value="\u54c1\u53f7\u9644\u4ef6\u4e0b\u8f7d\u63a5\u53e3", notes="\u54c1\u53f7\u9644\u4ef6\u4e0b\u8f7d\u63a5\u53e3")
    @ApiOperationSupport(order=19)
    public void fileDownload(String docId, String fileName, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtils.isEmpty((String)docId)) {
            throw new BaseException("\u8bf7\u8f93\u5165docId");
        }
        if (docId.length() != 10) {
            throw new BaseException("docId\u957f\u5ea6\u9519\u8bef");
        }
        if (StringUtils.isEmpty((String)fileName)) {
            throw new BaseException("\u8bf7\u8f93\u5165fileName");
        }
        try {
            String filePath = "D:/DocLibrary/" + docId.substring(3, 7) + "000/" + docId + ".001";
            String realFileName = System.currentTimeMillis() + fileName;
            response.setContentType("application/octet-stream");
            FileUtils.setAttachmentResponseHeader((HttpServletResponse)response, (String)realFileName);
            FileUtils.writeBytes((String)filePath, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    @GetMapping(value={"/analysisWorkOrders"})
    @ApiOperation(value="\u5de5\u5355\u9f50\u5957\u5206\u6790", notes="\u5de5\u5355\u9f50\u5957\u5206\u6790")
    @ApiOperationSupport(order=15)
    public Result<List<AnalysisWorkOrders>> analysisWorkOrders(AnalysisWorkOrders analysisWorkOrders) {
        if (StringUtils.isEmpty((String)analysisWorkOrders.getCompanyId())) {
            return new Result(500, "\u8bf7\u8f93\u5165companyId", null);
        }
        return this.adjustmentService.analysisWorkOrders(analysisWorkOrders);
    }
}

