/*
 * Decompiled with CFR 0.152.
 */
package com.fire.yf.controller.cus.edi;

import com.alibaba.fastjson.JSON;
import com.fire.base.exception.BaseException;
import com.fire.base.utils.StringUtils;
import com.fire.base.utils.TimeUtils;
import com.fire.yf.common.properties.ReadProperties;
import com.fire.yf.entity.basic.ExportShippingNotice;
import com.fire.yf.entity.basic.ExportShippingNoticeBody;
import com.fire.yf.entity.edi.CusId;
import com.fire.yf.entity.edi.Order;
import com.fire.yf.entity.edi.OrderBody;
import com.fire.yf.entity.erp.CMSMB;
import com.fire.yf.entity.erp.CMSMG;
import com.fire.yf.entity.erp.COPMA;
import com.fire.yf.entity.erp.INVMB;
import com.fire.yf.mapper.OrderSchedulingMapper;
import com.fire.yf.service.IBasicService;
import com.fire.yf.service.impl.BaseService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderService
extends BaseService {
    private static final Logger log = LoggerFactory.getLogger(OrderService.class);
    public static final String commonRemark = "\u5b9a\u65f6\u4efb\u52a1\u521b\u5efa";
    @Autowired
    private OrderSchedulingMapper orderSchedulingMapper;
    @Autowired
    private ReadProperties readProperties;
    @Autowired
    private IBasicService basicService;

    public void addOrderBefore(Integer size) {
        log.info("--------start-addOrder------------");
        String time8 = TimeUtils.getCurrentTime((String)"yyyyMMdd");
        String time17 = TimeUtils.getCurrentTime();
        Map map = this.orderSchedulingMapper.selectOrderId();
        String orderId = map.get("orderId") + "";
        if (StringUtils.isNull((Object)size)) {
            size = 100;
        }
        List list = this.orderSchedulingMapper.selectOriginalOrder(orderId, size.intValue());
        String maxId = orderId;
        for (Map mapHead : list) {
            try {
                String cusNoMerge = mapHead.get("nad_dp") + "";
                String cusNo = "";
                cusNo = "319-DT".equals(cusNoMerge) ? "KH-004" : "KH-003";
                String id = mapHead.get("id") + "";
                String cusOddNumber = this.generateCusOddNumber(mapHead, cusNoMerge);
                String rffOn = mapHead.get("rff_on") + "";
                if (Long.parseLong(maxId) < Long.parseLong(id)) {
                    maxId = id;
                }
                List listBody = this.orderSchedulingMapper.selectOriginalOrderBody(id);
                COPMA copma = new COPMA();
                copma.setMa001(cusNo);
                Map copmaDto = this.getCOPMA(copma);
                if (StringUtils.isNull((Object)copmaDto)) {
                    log.info("\u9519\u8bef");
                    log.info("\u5ba2\u6237\u7f16\u53f7\u4e0d\u5b58\u5728");
                    this.insertExceptionBill(new CusId("1-" + mapHead.get("id"), null, "1", "0"));
                    continue;
                }
                CMSMB cmsmb = new CMSMB();
                List cmsmbList = this.getCMSMB(cmsmb);
                String mb001 = ((Map)cmsmbList.get(0)).get("mb001") + "";
                Order order = new Order();
                order.setCompanyId(this.readProperties.database);
                order.setBillDate(time8);
                order.setCompanyNumber(cusNo);
                order.setDepartment(copmaDto.get("ma015") + "");
                order.setSalesman(copmaDto.get("ma016") + "");
                order.setFactoryNumber(mb001);
                order.setCusOddNumber(cusOddNumber);
                order.setDeliveryAddress("");
                order.setRemarkHead(commonRemark);
                if ("KH-003".equals(order.getCompanyNumber())) {
                    order.setTax("3");
                } else {
                    order.setTax(copmaDto.get("ma038") + "");
                }
                order.setProject("********************");
                order.setErpNo("DS");
                int i = 1;
                String currency = "";
                ArrayList<OrderBody> listO = new ArrayList<OrderBody>();
                order.setDetailList(listO);
                for (Map mapBody : listBody) {
                    String deliveryDate = TimeUtils.getDateTime((Date)((Date)mapBody.get("deliveryDate")), (String)"yyyyMMdd");
                    String serialNumber = this.getSerialNumber(i++);
                    if (StringUtils.isNull(mapBody.get("matCode"))) {
                        log.info("\u9519\u8bef");
                        log.info("\u5ba2\u6237\u54c1\u53f7\u4e3a\u7a7a");
                        this.insertExceptionBill(new CusId("2-" + mapBody.get("id"), null, "1", "0"));
                        continue;
                    }
                    String matCode = mapBody.get("matCode") + "";
                    String goodsNo = this.orderSchedulingMapper.selectCOPMG(cusNo, matCode);
                    if (StringUtils.isEmpty((String)goodsNo)) {
                        log.info("\u9519\u8bef");
                        log.info("\u54c1\u53f7\u4e3a\u7a7a");
                        this.insertExceptionBill(new CusId("2-" + mapBody.get("id"), null, "1", "0"));
                        continue;
                    }
                    INVMB invmb = new INVMB();
                    invmb.setMb001(goodsNo);
                    Map invmbDto = this.getINVMB(invmb);
                    if (StringUtils.isEmpty((Map)invmbDto)) {
                        log.info("\u9519\u8bef");
                        log.info("\u54c1\u53f7\u4e0d\u5b58\u5728");
                        this.insertExceptionBill(new CusId("2-" + mapBody.get("id"), null, "1", "0"));
                        continue;
                    }
                    OrderBody orderBody = new OrderBody();
                    try {
                        currency = mapBody.get("refCurrency") + "";
                        listO.add(orderBody);
                        orderBody.setSerialNumber(serialNumber);
                        orderBody.setGoodNumber(goodsNo);
                        orderBody.setUnit(invmbDto.get("mb004") + "");
                        try {
                            orderBody.setCount(Double.valueOf(Double.parseDouble(mapBody.get("qty") + "")));
                        }
                        catch (Exception e) {
                            orderBody.setCount(Double.valueOf(0.0));
                        }
                        try {
                            orderBody.setUnitPrice(Double.valueOf(Double.parseDouble(mapBody.get("refPrice") + "")));
                        }
                        catch (Exception e) {
                            orderBody.setUnitPrice(Double.valueOf(0.0));
                        }
                        order.setDeliveryDateHead(deliveryDate);
                        orderBody.setDeliveryDateBody(deliveryDate);
                        orderBody.setGift(Double.valueOf(0.0));
                        orderBody.setRemarkBody("");
                        if ("KH-003".equals(order.getCompanyNumber())) {
                            orderBody.setTaxRate(Double.valueOf(0.0));
                        } else {
                            orderBody.setTaxRate(Double.valueOf(((BigDecimal)invmbDto.get("mb111")).doubleValue()));
                        }
                        orderBody.setCusGoodsNo(matCode);
                        Integer linNo = (Integer)mapBody.get("linNo");
                        orderBody.setUdf06(String.valueOf(linNo));
                        orderBody.setUdf01(rffOn);
                        orderBody.setUdf02(cusNoMerge);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.info("\u8d4b\u503c\u9519\u8bef");
                        this.insertExceptionBill(new CusId("2-" + mapBody.get("id"), null, "1", "0"));
                    }
                }
                CMSMG cmsmg = new CMSMG();
                cmsmg.setMg001(copmaDto.get("ma014") + "");
                Map cmsmgDto = this.getCMSMG(cmsmg);
                order.setCurrency(copmaDto.get("ma014") + "");
                if (StringUtils.isNull((Object)cmsmgDto)) {
                    order.setExchangeRate(Double.valueOf(1.0));
                } else {
                    try {
                        order.setExchangeRate(Double.valueOf(((BigDecimal)cmsmgDto.get("mg003")).doubleValue()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        order.setExchangeRate(Double.valueOf(1.0));
                    }
                }
                this.basicService.addOrder(order);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.insertExceptionBill(new CusId("1-" + mapHead.get("id"), null, "1", "0"));
            }
        }
        CusId cusId = new CusId();
        cusId.setOrderId(maxId);
        this.orderSchedulingMapper.updateCusId(cusId);
        log.info("--------end-addOrder------------");
    }

    private String generateCusOddNumber(Map mapHead, String cusNoMerge) {
        String suffix = "";
        String s = cusNoMerge.split("-")[1];
        if (!"DT".equals(s)) {
            suffix = " DDR";
        }
        String week = TimeUtils.getWeek((Date)((Date)mapHead.get("doc_date")));
        String newWeek = "";
        String year = TimeUtils.getDateTime((Date)((Date)mapHead.get("doc_date")), (String)"yy");
        newWeek = Integer.parseInt(week) + 1 + "";
        if (newWeek.length() == 1) {
            newWeek = "0" + newWeek;
        }
        log.info("\u751f\u6210\u7684\u5ba2\u6237\u5355\u53f7");
        log.info(year);
        log.info(newWeek);
        log.info(suffix);
        return "W" + year + newWeek + suffix;
    }

    private void insertExceptionBill(CusId cusId) {
        int i = this.orderSchedulingMapper.insertExceptionOrder(cusId);
    }

    public void addShippingNoticeBefore(Integer size) {
        List listTemp;
        log.info("--------start-addShippingNotice------------");
        String time8 = TimeUtils.getCurrentTime((String)"yyyyMMdd");
        String time17 = TimeUtils.getCurrentTime();
        Map map = this.orderSchedulingMapper.selectOrderId();
        String orderId = map.get("orderId") + "";
        if (StringUtils.isNull((Object)size)) {
            size = 100;
        }
        if ((listTemp = this.orderSchedulingMapper.selectOriginalOrder(orderId, size.intValue())).size() > 0) {
            log.info("\u8ba2\u5355\u5c1a\u672a\u540c\u6b65\u5b8c\u6bd5\uff0c\u6682\u65f6\u8df3\u8fc7");
            return;
        }
        String sendOrderId = map.get("sendOrderId") + "";
        List list = this.orderSchedulingMapper.selectOriginalShippingNotice(sendOrderId, size.intValue());
        String maxId = sendOrderId;
        for (Map mapHead : list) {
            try {
                String cusNoMerge = mapHead.get("receiver_address") + "";
                String cusNo = "";
                cusNo = "319-DT".equals(cusNoMerge) ? "KH-004" : "KH-003";
                String consignmentNumber = mapHead.get("consignment_number") + "";
                String id = mapHead.get("id") + "";
                if (Long.parseLong(maxId) < Long.parseLong(id)) {
                    maxId = id;
                }
                List listBody = this.orderSchedulingMapper.selectOriginalShippingNoticeBody(id, this.readProperties.database);
                COPMA copma = new COPMA();
                copma.setMa001(cusNo);
                Map copmaDto = this.getCOPMA(copma);
                if (StringUtils.isNull((Object)copmaDto)) {
                    log.error("\u9519\u8bef");
                    log.error("\u5ba2\u6237\u7f16\u53f7\u4e0d\u5b58\u5728");
                    this.insertExceptionBill(new CusId(null, "1-" + mapHead.get("id"), "1", "0"));
                    continue;
                }
                CMSMB cmsmb = new CMSMB();
                List cmsmbList = this.getCMSMB(cmsmb);
                String mb001 = ((Map)cmsmbList.get(0)).get("mb001") + "";
                ExportShippingNotice exportShippingNotice = new ExportShippingNotice();
                exportShippingNotice.setCompanyId(this.readProperties.database);
                String oddType = this.getOddType("B1", this.readProperties.database);
                if (StringUtils.isEmpty((String)oddType)) {
                    throw new BaseException("\u8be5\u5ba2\u6237\u6ca1\u6709\u505a\u8fc7\u51fa\u53e3\u6a21\u5757\u7684\u51fa\u8d27\u901a\u77e5\u5355");
                }
                exportShippingNotice.setTa001(oddType);
                exportShippingNotice.setTa003(time8);
                exportShippingNotice.setTa004(cusNo);
                exportShippingNotice.setTa022("RMB");
                exportShippingNotice.setTa023(1.0);
                exportShippingNotice.setTa041(mb001);
                exportShippingNotice.setTa065(commonRemark);
                exportShippingNotice.setUserName("DS");
                exportShippingNotice.setTa042(consignmentNumber);
                exportShippingNotice.setUdf01(consignmentNumber);
                ArrayList<ExportShippingNoticeBody> listO = new ArrayList<ExportShippingNoticeBody>();
                exportShippingNotice.setDetailList(listO);
                for (Map mapBody : listBody) {
                    log.info("\u5f00\u59cb\u6253\u5370\u6bcf\u4e00\u4e2a\u5355\u8eab");
                    log.info(JSON.toJSONString((Object)mapBody));
                    ExportShippingNoticeBody exportShippingNoticeBody = new ExportShippingNoticeBody();
                    if (StringUtils.isEmpty((String)(mapBody.get("td001") + "")) || StringUtils.isEmpty((String)(mapBody.get("td002") + "")) || StringUtils.isEmpty((String)(mapBody.get("td003") + ""))) {
                        log.error("\u9519\u8bef");
                        log.error("\u6ca1\u6709\u5173\u8054\u7684\u8ba2\u5355\u5355\u522b\u5355\u53f7\u5e8f\u53f7");
                        log.error(JSON.toJSONString((Object)mapBody));
                        this.insertExceptionBill(new CusId(null, "2-" + mapHead.get("id") + "-" + mapBody.get("id"), "1", "0"));
                        continue;
                    }
                    exportShippingNoticeBody.setTb004(mapBody.get("td001") + "");
                    exportShippingNoticeBody.setTb005(mapBody.get("td002") + "");
                    exportShippingNoticeBody.setTb006(mapBody.get("td003") + "");
                    exportShippingNoticeBody.setTb009(Double.parseDouble(mapBody.get("qty") + ""));
                    exportShippingNoticeBody.setTb012(((BigDecimal)mapBody.get("td011")).doubleValue());
                    exportShippingNoticeBody.setUdf02(mapBody.get("order_number") + "");
                    listO.add(exportShippingNoticeBody);
                }
                if (StringUtils.isNull((Object)exportShippingNotice.getDetailList()) || exportShippingNotice.getDetailList().size() < 1) {
                    log.info("\u5355\u8eab\u4e3a\u7a7a");
                    log.info("\u51c6\u5907\u8df3\u8fc7");
                    continue;
                }
                this.basicService.createExportShippingNotice(exportShippingNotice);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u516c\u5171\u5904\u7406\u9519\u8bef");
                log.error(e.getMessage());
                this.insertExceptionBill(new CusId(null, "1-" + mapHead.get("id"), "1", "0"));
            }
        }
        CusId cusId = new CusId();
        cusId.setSendOrderId(maxId);
        this.orderSchedulingMapper.updateCusId(cusId);
        log.info("--------end-addShippingNotice------------");
    }

    public static void main(String[] args) {
        Date currentDate = new Date();
        System.out.println(currentDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(5, 5);
        Date date = calendar.getTime();
        System.out.println(date);
        String week = TimeUtils.getWeek((Date)date);
        String newWeek = "";
        String year = TimeUtils.getDateTime((Date)date, (String)"yy");
        int xingqiji = TimeUtils.dateToWeek((String)("20" + year + "-01-01"));
        newWeek = 2 == xingqiji ? Integer.parseInt(week) + 1 + "" : Integer.parseInt(week) + "";
        if (newWeek.length() == 1) {
            newWeek = "0" + newWeek;
        }
        System.out.println(newWeek);
    }
}

