/*
 * Decompiled with CFR 0.152.
 */
package com.fire.yf.controller.cus.plm;

import com.alibaba.fastjson.JSON;
import com.fire.base.common.AjaxResult;
import com.fire.base.common.Result;
import com.fire.base.exception.BaseException;
import com.fire.base.utils.StringUtils;
import com.fire.yf.entity.Bom;
import com.fire.yf.entity.Goods;
import com.fire.yf.entity.Inventory;
import com.fire.yf.entity.ProcurementInTransit;
import com.fire.yf.entity.Sup;
import com.fire.yf.service.IPlmService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSort;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSort(value=100)
@Api(value="plm")
@RestController
@RequestMapping(value={"/plm"})
public class PlmController {
    private static final Logger log = LoggerFactory.getLogger(PlmController.class);
    @Autowired
    private IPlmService plmService;

    @GetMapping(value={"/queryInventory"})
    @ApiOperation(value="\u67e5\u8be2\u5e93\u5b58", notes="\u67e5\u8be2\u5e93\u5b58")
    @ApiOperationSupport(order=10)
    public Result<List<Inventory>> queryInventory(Inventory inventory) {
        log.info(JSON.toJSONString((Object)inventory));
        if (StringUtils.isEmpty((String)inventory.getCompanyId())) {
            throw new BaseException("\u8bf7\u8f93\u5165\u516c\u53f8\u7f16\u53f7");
        }
        return this.plmService.queryInventory(inventory);
    }

    @GetMapping(value={"/queryProcurementInTransit"})
    @ApiOperation(value="\u67e5\u8be2\u91c7\u8d2d\u5728\u9014", notes="\u67e5\u8be2\u91c7\u8d2d\u5728\u9014")
    @ApiOperationSupport(order=30)
    public Result<List<ProcurementInTransit>> queryProcurementInTransit(ProcurementInTransit procurementInTransit) {
        log.info(JSON.toJSONString((Object)procurementInTransit));
        if (StringUtils.isEmpty((String)procurementInTransit.getCompanyId())) {
            throw new BaseException("\u8bf7\u8f93\u5165\u516c\u53f8\u7f16\u53f7");
        }
        return this.plmService.queryProcurementInTransit(procurementInTransit);
    }

    @PostMapping(value={"/createGoods"})
    @ApiOperation(value="\u54c1\u53f7\u65b0\u589e", notes="\u54c1\u53f7\u65b0\u589e")
    @ApiOperationSupport(order=31)
    public AjaxResult createGoods(@RequestBody Goods goods) {
        log.info(JSON.toJSONString((Object)goods));
        if (StringUtils.isEmpty((String)goods.getCompanyId())) {
            throw new BaseException("\u8bf7\u8f93\u5165\u516c\u53f8\u7f16\u53f7");
        }
        if (StringUtils.isEmpty((String)goods.getUserName())) {
            throw new BaseException("\u8bf7\u8f93\u5165\u521b\u5efa\u8005\u7f16\u53f7");
        }
        return this.plmService.createGoods(goods);
    }

    @PostMapping(value={"/createAndApproveBom"})
    @ApiOperation(value="bom\u65b0\u589e\u5e76\u5ba1\u6838", notes="bom\u65b0\u589e\u5e76\u5ba1\u6838")
    @ApiOperationSupport(order=31)
    public AjaxResult createAndApproveBom(@RequestBody Bom bom) {
        log.info(JSON.toJSONString((Object)bom));
        if (StringUtils.isEmpty((String)bom.getCompanyId())) {
            throw new BaseException("\u8bf7\u8f93\u5165\u516c\u53f8\u7f16\u53f7");
        }
        if (StringUtils.isEmpty((String)bom.getUserName())) {
            throw new BaseException("\u8bf7\u8f93\u5165\u521b\u5efa\u8005\u7f16\u53f7");
        }
        return this.plmService.createAndApproveBom(bom);
    }

    @PostMapping(value={"/updateAndApproveBom"})
    @ApiOperation(value="bom\u53cd\u5ba1\uff0c\u4fee\u6539\u5e76\u5ba1\u6838", notes="bom\u53cd\u5ba1\uff0c\u4fee\u6539\u5e76\u5ba1\u6838")
    @ApiOperationSupport(order=31)
    public AjaxResult updateAndApproveBom(@RequestBody Bom bom) {
        log.info(JSON.toJSONString((Object)bom));
        if (StringUtils.isEmpty((String)bom.getCompanyId())) {
            throw new BaseException("\u8bf7\u8f93\u5165\u516c\u53f8\u7f16\u53f7");
        }
        if (StringUtils.isEmpty((String)bom.getUserName())) {
            throw new BaseException("\u8bf7\u8f93\u5165\u521b\u5efa\u8005\u7f16\u53f7");
        }
        return this.plmService.updateBom(bom, null);
    }

    @GetMapping(value={"/querySup"})
    @ApiOperation(value="\u67e5\u8be2\u4f9b\u5e94\u5546", notes="\u67e5\u8be2\u4f9b\u5e94\u5546")
    @ApiOperationSupport(order=10)
    public Result<List<Sup>> querySup(Sup sup) {
        log.info(JSON.toJSONString((Object)sup));
        if (StringUtils.isEmpty((String)sup.getCompanyId())) {
            throw new BaseException("\u8bf7\u8f93\u5165\u516c\u53f8\u7f16\u53f7");
        }
        return this.plmService.querySup(sup);
    }

    @GetMapping(value={"/queryGoods"})
    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1", notes="\u67e5\u8be2\u5546\u54c1")
    @ApiOperationSupport(order=20)
    public Result<List<Goods>> queryGoods(Goods goods) {
        log.info(JSON.toJSONString((Object)goods));
        if (StringUtils.isEmpty((String)goods.getCompanyId())) {
            throw new BaseException("\u8bf7\u8f93\u5165\u516c\u53f8\u7f16\u53f7");
        }
        return this.plmService.queryGoods(goods);
    }
}

